#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from AddOneDoctor import AddOneDoctor
from OSEHRAHelper import PROMPT

def GoToUserManagementMenu(VistA):
  VistA.write('S DUZ=1 D ^XUP')
  VistA.wait('Select OPTION NAME')
  VistA.write('EVE\r1')
  VistA.wait('Select Systems Manager Menu Option:')
  VistA.write('USER MANAGEMENT')

def GoToPrompt(VistA):
  while True:
    index = VistA.multiwait(['Select User Management Option',
                             'Select Systems Manager Menu Option',
                             'Do you really want to halt'])
    VistA.write('')
    if index == 2:
      break
  VistA.wait(PROMPT)

def AddDoctors(VistA,state):
  GoToUserManagementMenu(VistA)
  if 'CALIFORNIA' == 'GEORGIA':
    # Primary Care Physician : GA PRIMARY CARE PROVIDER
    AddOneDoctor(VistA,'SMITH,JANE','JS','000000029','0383166994','F','fakedoc2'  ,'2Doc!@#$','JSMI123','769',   state + ' VA MEDICAL CENTER')
    # Orthopedist            : GA ORTHOPEDIST PROVIDER
    AddOneDoctor(VistA,'JOHNSON,MICHAEL','MJ','000000038','9382539572','M','fakecar2'   ,'3Car!@#$','JOHM123','776',   state + ' VA MEDICAL CENTER')
    # Mental Health          : GA MENTAL HEALTH PROVIDER
    AddOneDoctor(VistA,'CLARK,GEORGE','GC','000000041','0838136816','M','mhdoctor2'   ,'3Mhd!@#$','GEOK123','352',   state + ' VA MEDICAL CENTER')
    # Audiology (Ancilliary) : GA AUDIOLOGY ANCILLIARY
    AddOneDoctor(VistA,'KIRK,JOSEPH','JK','000000042','0625639600','M','audidoctor2'   ,'2Aud!@#$','JOEK123','239',   state + ' VA MEDICAL CENTER')
  elif 'CALIFORNIA' == 'ALABAMA':
    # Primary Care Physician : AL PRIMARY CARE PROVIDER
    AddOneDoctor(VistA,'SMITH,JAMES','JS','000000029','0507657696','M','fakedoc1'  ,'2Doc!@#$','SMIJ123','769',   state + ' VA MEDICAL CENTER')
    # Orthopedist            : AL ORTHOPEDIST PROVIDER
    AddOneDoctor(VistA,'JOHNSON,MICHAEL','MJ','000000038','9382539572','M','fakecar1'   ,'2Car!@#$','JOHM123','776',   state + ' VA MEDICAL CENTER')
    # Mental Health          : AL MENTAL HEALTH PROVIDER
    AddOneDoctor(VistA,'WILLIAMS,TIMOTHY','TW','000000039','0528050707','M','mhdoctor1'   ,'2Mhd!@#$','TIMW123','352',   state + ' VA MEDICAL CENTER')
    # Audiology (Ancilliary) : AL AUDIOLOGY ANCILLIARY
    AddOneDoctor(VistA,'ALEXANDER,ROBERT','RA','000000034','0720312863','M','audidoctor1'   ,'2Aud!@#$','ROBA123','239',   state + ' VA MEDICAL CENTER')
  GoToPrompt(VistA)

def AddDoctorsByConfig(VistA, doctorsJson):
  GoToUserManagementMenu(VistA)
  for doctor in doctorsJson:
    print doctor
    AddOneDoctor(VistA, doctor['Full Name'], doctor['Initials'],
                 doctor['SSN'], doctor['NPI'], doctor['Gender'],
                 doctor['Access Code'], doctor['Verify Code'],
                 doctor['Signature Code'], doctor['Person Class'],
                 doctor['Division Name'])
  GoToPrompt(VistA)
